       IDENTIFICATION DIVISION.
      *
       PROGRAM-ID.  PRODFILL.
      *
       ENVIRONMENT DIVISION.
      *
       DATA DIVISION.
      *
       WORKING-STORAGE SECTION.
      *
       01  SWITCHES.
      *
           05  VALID-DATA-SW                   PIC X   VALUE 'Y'.
               88  VALID-DATA                          VALUE 'Y'.
           05  CUSTOMER-FOUND-SW               PIC X   VALUE 'Y'.
               88  CUSTOMER-FOUND                      VALUE 'Y'.
           05  PRODUCT-FOUND-SW                PIC X   VALUE 'Y'.
               88  PRODUCT-FOUND                       VALUE 'Y'.
           05  VALID-QUANTITY-SW               PIC X   VALUE 'Y'.
               88  VALID-QUANTITY                      VALUE 'Y'.
           05  VALID-NET-SW                    PIC X   VALUE 'Y'.
               88  VALID-NET                           VALUE 'Y'.
      *
       01  FLAGS.
      *
           05  SEND-FLAG                       PIC X.
               88  SEND-ERASE                          VALUE '1'.
               88  SEND-DATAONLY                       VALUE '2'.
               88  SEND-DATAONLY-ALARM                 VALUE '3'.
           05  ATTRIBUTE-SET-FLAG              PIC X.
               88  SET-ATTRIBUTES                      VALUE '1'.
               88  RESET-ATTRIBUTES                    VALUE '2'.
      *
       01  WORK-FIELDS.
      *
           05  ITEM-SUB            PIC S9(3)   COMP-3  VALUE ZERO.
           05  LINE-ITEM-COUNT     PIC S9(3)   COMP-3  VALUE ZERO.
           05  NET-NUMERIC         PIC 9(7)V99.
           05  QTY-NUMERIC         PIC 9(5).
           05  PROD-RIDFLD         PIC 9(6).
      *
       01  RESPONSE-CODE           PIC S9(8)   COMP.
      *
       01  COMMUNICATION-AREA.
      *
           05  CA-CONTEXT-FLAG               PIC X.
               88  PROCESS-ENTRY                       VALUE '1'.
               88  PROCESS-VERIFY                      VALUE '2'.
           05  CA-TOTAL-ORDERS               PIC S9(3) COMP-3.
           05  CA-INVOICE-RECORD             PIC X(318).
           05  CA-FIELDS-ENTERED.
               10  CA-PO-ENTERED-SW          PIC X.
                   88  CA-PO-ENTERED                VALUE 'Y'.
               10  CA-LINE-ITEM              OCCURS 10.
                   15  CA-PCODE-ENTERED-SW   PIC X.
                       88  CA-PCODE-ENTERED         VALUE 'Y'.
                   15  CA-QTY-ENTERED-SW     PIC X.
                       88  CA-QTY-ENTERED           VALUE 'Y'.
                   15  CA-NET-ENTERED-SW     PIC X.
                       88  CA-NET-ENTERED           VALUE 'Y'.
      *
       01  REP-LINE.
      *
           05  TOTAL-RECS   PIC ZZ9.
           05  FILLER            PIC X(20) VALUE ' Recs entered.  Pr'.
           05  FILLER            PIC X(20) VALUE 'ess Enter to continu'.
           05  FILLER            PIC X(2)  VALUE 'e.'.

      *
       COPY PRODUCT.
      *
       COPY DFHAID.
      *
       COPY ATTR.
      *
       COPY ERRPARM.
      *
       LINKAGE SECTION.
      *
      *01  DFHCOMMAREA             PIC X(352).
      *
       01  COMMON-WORK-AREA.
      *
           05  CWA-DATE            PIC X(6).
           05  CWA-COMPANY-NAME    PIC X(40).
      *
       PROCEDURE DIVISION.
      *
       0000-ENTER-PRODUCTS.
      *
      *    MOVE DFHCOMMAREA TO COMMUNICATION-AREA.
           MOVE ZERO TO TOTAL-RECS.

           MOVE '1111111111' TO PRM-PRODUCT-CODE.
           MOVE 'ONE' TO  PRM-PRODUCT-DESCRIPTION.
           MOVE  11.11 TO PRM-UNIT-PRICE.
           MOVE  1111 TO PRM-QUANTITY-ON-HAND.
           PERFORM 1230-WRITE-PRODUCT-RECORD.
           MOVE 1 TO TOTAL-RECS.

           MOVE '2222222222' TO PRM-PRODUCT-CODE.
           MOVE 'TWO' TO  PRM-PRODUCT-DESCRIPTION.
           MOVE  22.22 TO PRM-UNIT-PRICE.
           MOVE  2222 TO PRM-QUANTITY-ON-HAND.
           PERFORM 1230-WRITE-PRODUCT-RECORD.
           MOVE 2 TO TOTAL-RECS.

           MOVE '3333333333' TO PRM-PRODUCT-CODE.
           MOVE 'THREE' TO  PRM-PRODUCT-DESCRIPTION.
           MOVE  33.33 TO PRM-UNIT-PRICE.
           MOVE  3333 TO PRM-QUANTITY-ON-HAND.
           PERFORM 1230-WRITE-PRODUCT-RECORD.
           MOVE 3 TO TOTAL-RECS.

      *    EXEC CICS
      *        RETURN TRANSID('MENU')
      *               COMMAREA(COMMUNICATION-AREA)
      *    END-EXEC.
      *
           STOP RUN.
       1230-WRITE-PRODUCT-RECORD.
      *
           EXEC CICS
               WRITE DATASET('PRODUCT')
                    FROM(PRODUCT-MASTER-RECORD)
                    RIDFLD(PROD-RIDFLD)
                    RESP(RESPONSE-CODE)
           END-EXEC.

           EXEC CICS
               SEND TEXT FROM(REP-LINE)
                         ERASE
                         FREEKB
           END-EXEC.

       9999-TERMINATE-PROGRAM.
      *
           MOVE EIBRESP  TO ERR-RESP.
           MOVE EIBRESP2 TO ERR-RESP2.
           MOVE EIBTRNID TO ERR-TRNID.
           MOVE EIBRSRCE TO ERR-RSRCE.
           EXEC CICS
               XCTL PROGRAM('SYSERR')
                    COMMAREA(ERROR-PARAMETERS)
           END-EXEC.
